%% CIS II Galen Kinematic Calibration 
%% Can Kocabalkanli, Spring 2020
%% Reads C, K, k_dof from csv files saved during virtual experiment, for delta test trajectory

function [C, K, k_dof] = get_test_data_2()


% Ideal Case
%TC = table2array(readtable('test_fwd_Kin_ideal_test_3000.csv'));
% Worst Case
%TC = table2array(readtable('test_fwd_kin_sys_error1_test_3000.csv'));
% Realistic Case
TC = table2array(readtable('test_fwd_kin_sys_error2_test_3000.csv'));

TK1 = table2array(readtable('delta_test_mk2_3000.csv'));

bh_pose = [-0.09 0.147 0.449];%[0 0 0];%[0.09 -0.147 -0.446 0 0 0];
ee_0_w = [0.75643 -0.1469409 0.29483197 0 0 0];

TB = [eye(3) bh_pose(1:3)'; 0 0 0 1];
%TB = [eye(3) [0 0 0]'; 0 0 0 1];

%TK2 = readtable('wrist_calibration.csv');


N = size(TK1, 1);
C = zeros(4,4,N);
T = zeros(4,4,N);
K = zeros(4,4,N);
k_dof = zeros(N, 5);
for i = 1:N
    kg1 = TK1(i,:).*1000;
    k_dof(i,:) = kg1;
    Rk = rotx(kg1(4))*roty(kg1(5));%rotz(kg1(6));%%THIS IS AN ASSUMPTION
    %Rk = eye(3);
    k1 = forwardKinematics(kg1(1), kg1(2), kg1(3), kg1(4), kg1(5));
    kg_t = k1(1:3) - [0 0 268.9]' + [0 0 0.54083*1000]';;  %; + bh_pose' - [0 0 268.9/1000]
    K(:,:,i) = [Rk kg_t; 0 0 0 1]; %TB \

    c1 = TC(i,:);
    c_t = c1(1:3)'*1000 - bh_pose'*1000; %!!! + [0 0 268.9]';%+ bh_pose'*1000 ; %- bh_pose(1:3)' - [0 0 268.9]';
    Rc = rotx(c1(6))*roty(c1(5))*rotz(c1(4));
    C(:,:,i) = [Rc c_t; 0 0 0 1];
    
    %C(:,:,i) = K(:,:,i)\T(:,:,i);
    
end



end